<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Page extends CI_Controller {

		public function __construct(){
        parent::__construct();
        $this->load->model('Categories_model');
    }

    public function index($slug){
		$page = $this->Settings_model->getPageBySlug($slug);
		if($page == NULL){
			redirect(base_url() . '404');
		}else{
			$data['title'] = $page['title'] . ' - ' . $this->Settings_model->general()["app_name"];
			$data['css'] = 'page';
			$data['page'] = $page;
			$this->load->view('templates/header', $data);
			$this->load->view('templates/navbar');
			$this->load->view('templates/subnavbar');
			$this->load->view('page/page', $page);
			$this->load->view('templates/footer_tmpl');
			$this->load->view('templates/footer_real');
		}
	}

	public function search(){
		$q = $_GET['q'];
		$data['products'] = $this->Products_model->searchProducts($q,"");
		$data['title'] = 'Hasil pencarian : ' . $q;
		$data['css'] = 'products';
		$data['responsive'] = 'product-responsive';
		$data['q'] = $q;
		$this->load->view('templates/header', $data);
		$this->load->view('templates/navbar');
		$this->load->view('templates/subnavbar');
		$this->load->view('page/search', $data);
		$this->load->view('templates/footer_tmpl');
		$this->load->view('templates/footer_real');
	}

	public function tracking(){
		$invoice = $_GET['invoice'];
		$wa = $_GET['wa'];
		$check = $this->db->get_where('invoice', ['invoice_code' => $invoice, 'telp' => $wa])->row_array();
		if($check){
			$data['order'] = $check;
			if($check['resi'] != ""){
				$check_resi = $check['resi'];
				$check_courier = $check['courier'];
				$curl = curl_init();
				curl_setopt_array($curl, array(
				CURLOPT_URL => "https://pro.rajaongkir.com/api/waybill",
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => "",
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 30,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => "POST",
				CURLOPT_POSTFIELDS => "waybill=$check_resi&courier=$check_courier",
				CURLOPT_HTTPHEADER => array(
					"content-type: application/x-www-form-urlencoded",
					"key: ". $this->Settings_model->general()["api_rajaongkir"]
				),
				));
				$response = curl_exec($curl);
				$err = curl_error($curl);
				curl_close($curl);
				if ($err) {
					echo "cURL Error #:" . $err;
				} else {
					$response = json_decode($response, true);
					usort($response['rajaongkir']['result']['manifest'],function($a,$b) {
						return strtotime($b['manifest_date'] . ' ' . $b['manifest_time']) - strtotime($a['manifest_date'] . ' ' . $a['manifest_time']);
					});
					$data['waybill'] = $response['rajaongkir'];
					if($response['rajaongkir']['result']['delivered'] == true){
						$this->db->set('status', 3);
						$this->db->where('invoice_code', $invoice);
						$this->db->update('invoice');
						$data['order'] = $this->db->get_where('invoice', ['invoice_code' => $invoice, 'telp' => $wa])->row_array();
					}
				}
			}
		}else {
			$data['order'] = "";
		}
		$data['title'] = 'Cek Pesanan - ' . $this->Settings_model->general()['app_name'];
		$data['css'] = 'tracking';
		$data['invoice'] = $invoice;
		$data['wa'] = $wa;
		$this->load->view('templates/header', $data);
		$this->load->view('templates/navbar');
		$this->load->view('templates/subnavbar');
		$this->load->view('page/tracking', $data);
		$this->load->view('templates/footer_tmpl');
		$this->load->view('templates/footer_real');
	}


}
