<?php echo $this->session->flashdata('upload'); ?>
<h1 class="h4 mb-2">Pengaturan Pengiriman</h1>

<div class="card">
    <div class="card-body">
        <ul class="nav nav-pills">
            <li class="nav-item">
                <a class="flex-sm-fill text-secondary nav-link" href="<?= base_url(); ?>administrator/setting/account"><i class="uil-user-circle"></i> Akun</a>
            </li>
            <li class="nav-item">
                <a class="flex-sm-fill text-secondary nav-link" href="<?= base_url(); ?>administrator/setting/payment"><i class="uil-usd-circle"></i> Pembayaran</a>
            </li>
            <li class="nav-item">
                <a class="flex-sm-fill text-primary nav-link" href="<?= base_url(); ?>administrator/setting/shipping"><i class="uil-truck"></i> Pengiriman</a>
            </li>
            <li class="nav-item">
                <a class="flex-sm-fill text-secondary nav-link" href="<?= base_url(); ?>administrator/setting/notification"><i class="uil-comment-alt-dots"></i> Notifikasi</a>
            </li>
            <li class="nav-item">
                <a class="flex-sm-fill text-secondary nav-link" href="<?= base_url(); ?>administrator/setting/pixel"><i class="uil-facebook"></i> Pixel</a>
            </li>
            <li class="nav-item">
                <a class="flex-sm-fill text-secondary nav-link" href="<?= base_url(); ?>administrator/setting/seo"><i class="uil-google"></i> SEO</a>
            </li>
        </ul>
    </div>
    <hr class="mt-0 mb-0">
    <div class="card-body">
        <div class="mb-4">
            <a href="<?= base_url(); ?>administrator/setting/shipping" class="<?= isset($_GET['flat']) == "true" ? "text-secondary" : "font-weight-bold" ?>">Raja Ongkir</a>
            <span class="mx-1">|</span>
            <a href="<?= base_url(); ?>administrator/setting/shipping?flat=true" class="<?= isset($_GET['flat']) == "true" ? "font-weight-bold" : "text-secondary" ?>">Flat Ongkir</a>
        </div>
        <div class="alert alert-success" id="msgSettingPayment" style="display: none"></div>
        <?php if (isset($_GET['flat']) == "true") { ?>
            <div class="custom-control mr-5 custom-switch">
                <?php if ($setting['flatshipping_feature'] == 1) { ?>
                    <input type="checkbox" checked class="custom-control-input" id="flatShippingFeatureSetting">
                <?php } else { ?>
                    <input type="checkbox" class="custom-control-input" id="flatShippingFeatureSetting">
                <?php } ?>
                <label class="custom-control-label" for="flatShippingFeatureSetting">Aktifkan Fitur Flat Ongkir</label>
            </div>
            <small class="text-success" style="display: none" id="msgShippingSettingPage"></small>
            <form action="<?= base_url(); ?>administrator/save_setting_flat_ongkir" method="post">
                <?php foreach ($flat_ongkir->result_array() as $ongkir) : ?>
                    <div class="form-group mt-3" id="formSectionSettingShipping-<?= $ongkir['id']; ?>">
                        <div class="row">
                            <div class="col-md-3">
                                <input type="text" name="location[]" id="location" autocomplete="off" class="form-control" placeholder="Lokasi" value="<?= $ongkir['location']; ?>">
                            </div>
                            <div class="col-md-3">
                                <input type="text" name="fee[]" id="fee" autocomplete="off" class="form-control" placeholder="Biaya Ongkir" value="<?= $ongkir['fee']; ?>">
                            </div>
                            <input type="hidden" name="shippingId[]" value="<?= $ongkir['id']; ?>">
                            <div class="col-sm-1">
                                <i onclick="deleteFlatOngkir('<?= $ongkir['id']; ?>')" style="cursor: pointer" class="fa mt-2 fa-trash h4 text-danger"></i>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
                <div class="form-add-flatongkir-in-shipping-page">
                    <div class="form-group mt-3" id="formSectionSettingShipping-1">
                        <div class="row">
                            <div class="col-md-3">
                                <input type="text" name="location[]" id="location" autocomplete="off" placeholder="Lokasi" class="form-control">
                            </div>
                            <div class="col-md-3">
                                <input type="text" name="fee[]" id="fee" autocomplete="off" class="form-control" placeholder="Biaya Ongkir">
                            </div>
                            <input type="hidden" name="shippingId[]" value="0">
                            <div class="col-sm-1">
                                <i onclick="removeFlatOngkirForm('1')" style="cursor: pointer" class="fa mt-2 fa-trash h4 text-danger"></i>
                            </div>
                        </div>
                    </div>
                </div>
                <button id="btnAddFormFlatOngkirSetting" type="button" class="btn btn-outline-primary">Tambah Pilihan</button><br>
                <button type="submit" class="btn mt-3 btn-primary px-4">Simpan Pengaturan</button>
            </form>
        <?php } else { ?>
            <div class="custom-control mr-5 custom-switch">
                <?php if ($setting['shipping_feature'] == 1) { ?>
                    <input type="checkbox" checked class="custom-control-input" id="shippingFeatureSetting">
                <?php } else { ?>
                    <input type="checkbox" class="custom-control-input" id="shippingFeatureSetting">
                <?php } ?>
                <label class="custom-control-label" for="shippingFeatureSetting">Aktifkan Fitur Raja Ongkir</label>
            </div>
            <small class="text-success" style="display: none" id="msgShippingSettingPage"></small>
            <form action="<?= base_url(); ?>administrator/setting/shipping" method="post">
                <div class="form-group mt-4">
                    <div class="row">
                        <div class="col-md-6">
                            <input type="password" placeholder="Api Key Rajaongkir Pro" autocomplete="off" name="api_rajaongkir" value="<?= $general['api_rajaongkir']; ?>" class="form-control">
                            <div class="form-group mt-3">
                                <label for="cityAdminSelectAddress">Masukan Kabupaten/ Kota</label>
                                <select name="city" id="cityAdminSelectAddress" class="form-control">
                                    <option value="<?= $selectRegency['city_id']; ?>"><?= $selectRegency['type']; ?> <?= $selectRegency['city']; ?></option>
                                    <?php foreach ($regency as $d) : ?>
                                        <option value="<?= $d['city_id'] ?>"><?= $d['type'] ?> <?= $d['city_name'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="subdistrictAdminSelectAddress">Masukan Kecamatan</label>
                                <select name="subdistrict" id="subdistrictAdminSelectAddress" class="form-control">
                                    <option value="<?= $selectRegency['subdistrict_id']; ?>">Kecamatan <?= $selectRegency['subdistrict_name']; ?></option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="d-block">
                        <div class="custom-control float-left custom-checkbox mb-3 mr-4">
                            <input type="checkbox" class="custom-control-input" id="shipping-pos" <?= $courier['pos'] == 1 ? "checked" : NULL ?> name="pos">
                            <label class="custom-control-label" for="shipping-pos">POS Indonesia</label>
                        </div>
                        <div class="custom-control float-left custom-checkbox mb-3 mr-4">
                            <input type="checkbox" class="custom-control-input" id="shipping-jne" <?= $courier['jne'] == 1 ? "checked" : NULL ?> name="jne">
                            <label class="custom-control-label" for="shipping-jne">JNE</label>
                        </div>
                        <div class="custom-control float-left custom-checkbox mb-3 mr-4">
                            <input type="checkbox" class="custom-control-input" id="shipping-lion" <?= $courier['lion'] == 1 ? "checked" : NULL ?> name="lion">
                            <label class="custom-control-label" for="shipping-lion">Lion Parcel</label>
                        </div>
                        <div class="custom-control float-left custom-checkbox mb-3 mr-4">
                            <input type="checkbox" class="custom-control-input" id="shipping-ninja" <?= $courier['ninja'] == 1 ? "checked" : NULL ?> name="ninja">
                            <label class="custom-control-label" for="shipping-ninja">Ninja Xpress</label>
                        </div>
                        <div class="custom-control float-left custom-checkbox mb-3 mr-4">
                            <input type="checkbox" class="custom-control-input" id="shipping-ide" <?= $courier['ide'] == 1 ? "checked" : NULL ?> name="ide">
                            <label class="custom-control-label" for="shipping-ide">ID Express</label>
                        </div>
                        <div class="custom-control float-left custom-checkbox mb-3 mr-4">
                            <input type="checkbox" class="custom-control-input" id="shipping-sicepat" <?= $courier['sicepat'] == 1 ? "checked" : NULL ?> name="sicepat">
                            <label class="custom-control-label" for="shipping-sicepat">SiCepat Express</label>
                        </div>
                        <div class="custom-control float-left custom-checkbox mb-3 mr-4">
                            <input type="checkbox" <?= $courier['sap'] == 1 ? "checked" : NULL ?> class="custom-control-input" id="shipping-sap" name="sap">
                            <label class="custom-control-label" for="shipping-sap">SAP Express</label>
                        </div>
                        <div class="custom-control float-left custom-checkbox mb-3 mr-4">
                            <input type="checkbox" <?= $courier['ncs'] == 1 ? "checked" : NULL ?> class="custom-control-input" id="shipping-ncs" name="ncs">
                            <label class="custom-control-label" for="shipping-ncs">Nusantara Card Semesta</label>
                        </div>
                        <div class="custom-control float-left custom-checkbox mb-3 mr-4">
                            <input type="checkbox" <?= $courier['anteraja'] == 1 ? "checked" : NULL ?> class="custom-control-input" id="shipping-anteraja" name="anteraja">
                            <label class="custom-control-label" for="shipping-anteraja">AnterAja</label>
                        </div>
                        <div class="custom-control float-left custom-checkbox mb-3 mr-4">
                            <input type="checkbox" class="custom-control-input" id="shipping-rex" <?= $courier['rex'] == 1 ? "checked" : NULL ?> name="rex">
                            <label class="custom-control-label" for="shipping-rex">Royal Express Indonesia</label>
                        </div>
                        <div class="custom-control float-left custom-checkbox mb-3 mr-4">
                            <input type="checkbox" class="custom-control-input" id="shipping-sc" <?= $courier['sc'] == 1 ? "checked" : NULL ?> name="sc">
                            <label class="custom-control-label" for="shipping-sc">Sentral Cargo</label>
                        </div>
                        <div class="custom-control float-left custom-checkbox mb-3 mr-4">
                            <input type="checkbox" class="custom-control-input" id="shipping-tiki" <?= $courier['tiki'] == 1 ? "checked" : NULL ?> name="tiki">
                            <label class="custom-control-label" for="shipping-tiki">TIKI</label>
                        </div>
                        <div class="custom-control float-left custom-checkbox mb-3 mr-4">
                            <input type="checkbox" class="custom-control-input" id="shipping-rpx" <?= $courier['rpx'] == 1 ? "checked" : NULL ?> name="rpx">
                            <label class="custom-control-label" for="shipping-rpx">RPX Holding</label>
                        </div>
                        <div class="custom-control float-left custom-checkbox mb-3 mr-4">
                            <input type="checkbox" class="custom-control-input" id="shipping-pandu" <?= $courier['pandu'] == 1 ? "checked" : NULL ?> name="pandu">
                            <label class="custom-control-label" for="shipping-pandu">Pandu Logistics</label>
                        </div>
                        <div class="custom-control float-left custom-checkbox mb-3 mr-4">
                            <input type="checkbox" class="custom-control-input" id="shipping-wahana" <?= $courier['wahana'] == 1 ? "checked" : NULL ?> name="wahana">
                            <label class="custom-control-label" for="shipping-wahana">Wahana</label>
                        </div>
                        <div class="custom-control float-left custom-checkbox mb-3 mr-4">
                            <input type="checkbox" <?= $courier['jnt'] == 1 ? "checked" : NULL ?> class="custom-control-input" id="shipping-jnt" name="jnt">
                            <label class="custom-control-label" for="shipping-jnt">J&T Express</label>
                        </div>
                        <div class="custom-control float-left custom-checkbox mb-3 mr-4">
                            <input type="checkbox" <?= $courier['pahala'] == 1 ? "checked" : NULL ?> class="custom-control-input" id="shipping-pahala" name="pahala">
                            <label class="custom-control-label" for="shipping-pahala">Pahala</label>
                        </div>
                        <div class="custom-control float-left custom-checkbox mb-3 mr-4">
                            <input type="checkbox" <?= $courier['jet'] == 1 ? "checked" : NULL ?> class="custom-control-input" id="shipping-jet" name="jet">
                            <label class="custom-control-label" for="shipping-jet">JET Express</label>
                        </div>
                        <div class="custom-control float-left custom-checkbox mb-3 mr-4">
                            <input type="checkbox" <?= $courier['slis'] == 1 ? "checked" : NULL ?> class="custom-control-input" id="shipping-slis" name="slis">
                            <label class="custom-control-label" for="shipping-slis">Solusi Ekspres</label>
                        </div>
                        <div class="custom-control float-left custom-checkbox mb-3 mr-4">
                            <input type="checkbox" <?= $courier['expedito'] == 1 ? "checked" : NULL ?> class="custom-control-input" id="shipping-expedito" name="expedito">
                            <label class="custom-control-label" for="shipping-expedito">Expedito</label>
                        </div>
                        <div class="custom-control float-left custom-checkbox mb-3 mr-4">
                            <input type="checkbox" <?= $courier['dse'] == 1 ? "checked" : NULL ?> class="custom-control-input" id="shipping-dse" name="dse">
                            <label class="custom-control-label" for="shipping-dse">21 Express</label>
                        </div>
                        <div class="custom-control float-left custom-checkbox mb-3 mr-4">
                            <input type="checkbox" <?= $courier['first'] == 1 ? "checked" : NULL ?> class="custom-control-input" id="shipping-first" name="first">
                            <label class="custom-control-label" for="shipping-first">First Logistics</label>
                        </div>
                        <div class="custom-control float-left custom-checkbox mb-3 mr-4">
                            <input type="checkbox" <?= $courier['star'] == 1 ? "checked" : NULL ?> class="custom-control-input" id="shipping-star" name="star">
                            <label class="custom-control-label" for="shipping-star">Star Cargo</label>
                        </div>
                        <div class="custom-control float-left custom-checkbox mb-3 mr-4">
                            <input type="checkbox" <?= $courier['idl'] == 1 ? "checked" : NULL ?> class="custom-control-input" id="shipping-idl" name="idl">
                            <label class="custom-control-label" for="shipping-idl">IDL Cargo</label>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
                <button class="btn btn-primary px-4">Simpan Pengaturan</button>
            </form>
        <?php } ?>
    </div>
</div>

<script src="<?= base_url(); ?>assets/admin/libs/jquery/jquery.min.js"></script>
<script>
    let globalIdFormFlatOngkirSetting = 2;
    $("#btnAddFormFlatOngkirSetting").on("click", function() {
        $(".form-add-flatongkir-in-shipping-page").append(`
        <div class="form-group mt-3" id="formSectionSettingShipping-${globalIdFormFlatOngkirSetting}">
            <div class="row">
                <div class="col-md-3">
                    <input type="text" name="location[]" id="location" autocomplete="off" placeholder="Lokasi" class="form-control">
                </div>
                <div class="col-md-3">
                    <input type="text" name="fee[]" id="fee" autocomplete="off" class="form-control" placeholder="Biaya Ongkir">
                </div>
                <input type="hidden" name="shippingId[]" value="0">
                <div class="col-sm-1">
                    <i onclick="removeFlatOngkirForm('${globalIdFormFlatOngkirSetting}')" style="cursor: pointer" class="fa mt-2 fa-trash h4 text-danger"></i>
                </div>
            </div>
        </div>
        `);
        globalIdFormFlatOngkirSetting += 1;
    })

    function removeFlatOngkirForm(id) {
        $(`#formSectionSettingShipping-${id}`).slideUp('fast');
    }
</script>