<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Cart extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Categories_model');
        $this->load->model('Products_model');
        $this->load->library('cart');
    }

    public function add_to_cart()
    {
        $id = $this->input->post('id');
        $slug = $this->input->post('slug');
        $color = $this->input->post('color');
        $size = $this->input->post('size');
        $setting = $this->db->get('settings')->row_array();
        $result = $this->db->get_where('products', ['id' => $id])->row_array();
        if ($size != NULL) {
            $dbSize = $this->db->get_where('variant', ['type' => $size, 'product' => $id])->row_array();
            if ($result['discount'] == 0) {
                $price = $dbSize['price'];
            } else {
                $diskonnya = ($dbSize['price'] * $result['discount']) / 100;
                $price = $dbSize['price'] - $diskonnya;
            }
        } else {
            $size = "";
            if ($result['discount'] == 0) {
                $price = $result['price'];
            } else {
                $diskonnya = ($result['price'] * $result['discount']) / 100;
                $price = $result['price'] - $diskonnya;
            }
        }
        if ($color == NULL) {
            $color = "";
        }

        $this->db->where('id_product', $id);
        $this->db->where('count <=', $this->input->post('qty'));
        $this->db->order_by('id', 'desc');
        $getWholeSaler = $this->db->get('wholesaler')->row_array();
        if ($getWholeSaler) {
            if ($result['discount'] == 0) {
                $price = $getWholeSaler['price'];
            } else {
                $diskonnya = ($getWholeSaler['price'] * $result['discount']) / 100;
                $price = $getWholeSaler['price'] - $diskonnya;
            }
        }

        $productInCart = false;
        $rowidProductInCart = "";
        $qtyProductInCart = "";
        foreach ($this->cart->contents() as $item) {
            if ($item['slug'] == $slug && $item['option']['Variant'] == $size && $item['option']['Color'] == $color) {
                $productInCart = true;
                $rowidProductInCart = $item['rowid'];
                $qtyProductInCart = $item['qty'];
            }
        }
        if ($productInCart) {
            $qty = $qtyProductInCart + 1;
            $data = [
                'rowid' => $rowidProductInCart,
                'qty' => $qty,
            ];
            $this->cart->update($data);
        } else {
            $data = array(
                'id' => time(),
                'name' => $result['title'],
                'price' => $price,
                'qty' => $this->input->post('qty'),
                'img' => $result['img'],
                'ex_img' => $result['ex_img'],
                'slug' => $result['slug'],
                'weight' => $result['weight'],
                'option' => ['Variant' => $size, 'Color' => $color]
            );
            $this->cart->insert($data);
        }

        $list = "";
        foreach ($this->cart->contents() as $item) {
            $list .= '<div class="item-cart" id="modalCartBodyListItem-' . $item['rowid'] . '">';
            if ($item['ex_img'] == 1) {
                $list .= '<img src="' . $item["img"] . '" alt="img product" class="thumb-img">';
            } else {
                $list .= '<img src="' . base_url() . 'assets/images/product/' . $item["img"] . '" alt="img product" class="thumb-img">';
            }
            $list .= '<div class="text">
            <h4 class="product-name">' . $item['name'] . '</h4>
            <p class="information mb-0">' . $item["option"]["Color"] . ' - ' . $item["option"]["Variant"] . ' - ' . $item["weight"] . ' gr</p>
            <h5 class="price" id="modalCartPriceProduct-' . $item['rowid'] . '">Rp. ' . number_format($item['subtotal'], 0, ",", ".") . '</h5>
            </div>
            <div class="option">
            <div></div>
            <div class="qty">';
            $productt = $this->Products_model->getProductBySlug($item['slug']);
            $list .= '<button style="border-top-left-radius: 6px;border-bottom-left-radius: 6px;" onclick="minusProductCart(\'' . $item['rowid'] . '\')">-</button>
            <input style="outline: none;" type="text" value="' . $item['qty'] . '" id="qtyProductCart-' . $item['rowid'] . '" onkeyup="changeQtyProductCart(\'' . $item['rowid'] . '\', this.value)" class="valueJmlQty">
            <button style="border-top-right-radius: 6px;border-bottom-right-radius: 6px;" onclick="plusProductCart(\'' . $item['rowid'] . '\', ' . $productt['stock']  . ')">+</button>
            </div>
            </div>
            <i class="fa fa-trash text-danger" onclick="deleteCartByRowid(\'' . $item['rowid'] . '\')"></i>
            </div>';
        }
        $list .= '<div class="button-bottom-modal-cart-global">
                <button type="button" onclick="location.reload(true)" class="shopping-again" data-dismiss="modal">BELANJA LAGI</button>
                <a href="' . base_url() . 'checkout" class="checkout"><button>LANJUT CHECKOUT</button></a>
            </div>';

        echo $list;
    }

    public function get_item()
    {
        $rowid = $this->input->post('rowid');
        echo json_encode($this->cart->get_item($rowid));
    }

    public function add_ket()
    {
        $rowid = $this->input->post('rowid');
        $ket = $this->input->post('ket');
        $data = [
            'rowid' => $rowid,
            'ket' => $ket,
        ];
        $this->cart->update($data);
    }

    public function edit_qty_cart()
    {
        $type = $_GET['type'];
        $rowid = $this->input->post('rowid');
        $cart = $this->cart->get_item($rowid);
        if ($type == "minus") {
            $qty = $cart['qty'] - 1;
            $data = [
                'rowid' => $rowid,
                'qty' => $qty,
            ];
            $this->cart->update($data);
        } else if ($type == "plus") {
            $qty = $cart['qty'] + 1;
            $data = [
                'rowid' => $rowid,
                'qty' => $qty,
            ];
            $this->cart->update($data);
        } else if ($type == "random") {
            $qty = $this->input->post('qty');
            $data = [
                'rowid' => $rowid,
                'qty' => $qty
            ];
            $this->cart->update($data);
        }
        echo $this->cart->get_item($rowid)['subtotal'];
    }

    public function delete($id)
    {
        $data = [
            'rowid' => $id,
            'qty' => 0
        ];
        $this->cart->update($data);
    }

    public function delete_cart()
    {
        $this->cart->destroy();
        redirect(base_url() . 'cart');
    }
}
