<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Categories extends CI_Controller {

	public function __construct(){
		parent::__construct();
		$this->load->model('Categories_model');
		$this->load->model('Products_model');
	}

	public function index($c){
		$sort = $_GET['sort'];
		$cat = $this->Categories_model->getIdCategoryBySlug($c);
		if($sort != null){
			if($sort == "bestseller"){
				$data['products'] = $this->Products_model->getAllProductsByCategory($cat['id'],0,"bestseller");
			}else if($sort == "latest"){
				$data['products'] = $this->Products_model->getAllProductsByCategory($cat['id'],0,"latest");
			}else if($sort == "cheapest"){
				$data['products'] = $this->Products_model->getAllProductsByCategory($cat['id'],0,"cheapest");
			}else if($sort == "expensive"){
				$data['products'] = $this->Products_model->getAllProductsByCategory($cat['id'],0,"expensive");
			}else{
				$data['products'] = $this->Products_model->getAllProductsByCategory($cat['id'],0,"");	
			}
		}else{
			$data['products'] = $this->Products_model->getAllProductsByCategory($cat['id'],0,"");
		}
    	$data['title'] = 'Kategori ' . $this->Categories_model->getNameCategoryBySlug($c) . ' - ' . $this->Settings_model->general()["app_name"];
		$data['css'] = 'products';
		$data['category'] = $cat['name'];
		$data['responsive'] = 'product-responsive';
		$data['slug'] = $cat['slug'];
		$data['idCat'] = $cat['id'];
		$data['sort'] = $sort;
		$this->load->view('templates/header', $data);
		$this->load->view('templates/navbar');
		$this->load->view('templates/subnavbar');
		$this->load->view('page/categories', $data);
		$this->load->view('templates/footer_tmpl');
		$this->load->view('templates/footer_real');
	}

}
