<div class="d-sm-flex align-items-center justify-content-between mb-3">
    <h4 class="mb-0">Laporan Penjualan</h4>
    <button type="button" onclick="exportTableToExcel('dataTableReportPage','Laporan Penjualan <?= $date; ?>')" id="btnExportTableReportPage" class="btn px-3 btn-success">
		<i class="mdi mdi-download"></i> EXPORT
	</button>
</div>

<?php $totalomset = 0; foreach($report->result_array() as $data){
    $totalomset += $data['total_price'] + $data['uniq_number'] - $data['potongan'];
    $totalomset += $data['ongkir'];
} ?>
<div class="card shadow mb-4">
    <div class="card-body">
        <form action="<?= base_url(); ?>administrator/report" method="get">
        <div class="row">
            <div class="col-md-6">
                <label for="date1">Mulai</label>
                <input type="date" required name="date1" class="form-control" id="date1" value="<?= $_GET['date1'] ?>">
            </div>
            <div class="col-md-6">
                <label for="date2">Selesai</label>
                <input type="date" required name="date2" class="form-control" id="date2" value="<?= $_GET['date2'] ?>">
            </div>
        </div>
        <button type="submit" class="btn px-3 mt-2 btn-info">CARI LAPORAN</button>
        </form>
        <h4 class="mt-4 mb-1 text-center">LAPORAN PENJUALAN</h4>
        <p class="text-center">Periode : <?= $date; ?></p>
    </div>
	<div class="card-body">
        <p class="font-weight-bold mb-2 float-right">Total Omset: Rp. <?= number_format($totalomset,0,",",".") ?></p>
		<?php if($report->num_rows() > 0){ ?>
		<div class="table-responsive">
			<table
				class="table table-bordered"
				id="dataTableReportPage"
                border="1"
			>
				<thead>
					<tr class="thead-light">
						<th>No</th>
						<th>Tanggal</th>
						<th>Order ID</th>
						<th>Nama</th>
						<th>Harga Produk</th>
						<th>Ongkos Kirim</th> 
					</tr>
				</thead>
				<tfoot></tfoot>
				<tbody class="data-content">
					<?php $no=1; $allproductprice = 0; $allongkir = 0; foreach($report->result_array() as $data): ?>
                    <?php $allproductprice += $data['total_price'] + $data['uniq_number'] - $data['potongan']; $allongkir += $data['ongkir']; ?>
					<tr>
						<td><?= $no; ?></td>
						<td><?= date('d-m-Y H:i', strtotime($data['date_input'])); ?></td>
						<td><?= $data['invoice_code']; ?></td>
						<td><?= $data['name']; ?></td>
						<td>Rp. <?= number_format($data['total_price'] + $data['uniq_number'] - $data['potongan'],0,",","."); ?></td>
						<td>Rp. <?= number_format($data['ongkir'],0,",","."); ?></td>
					</tr>
					<?php $no++; endforeach; ?>
                    <tr>
                        <td colspan="4" class="text-center font-weight-bold">TOTAL</td>
                        <td class="font-weight-bold">Rp. <?= number_format($allproductprice,0,",","."); ?></td>
                        <td class="font-weight-bold">Rp. <?= number_format($allongkir,0,",","."); ?></td>
                    </tr>
				</tbody>
			</table>
		</div>
		<?php }else{ ?>
			<div class="alert alert-warning" role="alert">
                Belum ada pesanan.
            </div>
		<?php } ?>
	</div>
</div>