<?php echo $this->session->flashdata('upload'); ?>
<h1 class="h4 mb-2">Pengaturan Pembayaran</h1>

<div class="card">
    <div class="card-body">
    <ul class="nav nav-pills">
            <li class="nav-item">
                <a class="flex-sm-fill text-secondary nav-link" href="<?= base_url(); ?>administrator/setting/account"><i class="uil-user-circle"></i> Akun</a>
            </li>
            <li class="nav-item">
                <a class="flex-sm-fill text-primary nav-link" href="<?= base_url(); ?>administrator/setting/payment"><i class="uil-usd-circle"></i> Pembayaran</a>
            </li>
            <li class="nav-item">
                <a class="flex-sm-fill text-secondary nav-link" href="<?= base_url(); ?>administrator/setting/shipping"><i class="uil-truck"></i> Pengiriman</a>
            </li>
            <li class="nav-item">
                <a class="flex-sm-fill text-secondary nav-link" href="<?= base_url(); ?>administrator/setting/notification"><i class="uil-comment-alt-dots"></i> Notifikasi</a>
            </li>
            <li class="nav-item">
                <a class="flex-sm-fill text-secondary nav-link" href="<?= base_url(); ?>administrator/setting/pixel"><i class="uil-facebook"></i> Pixel</a>
            </li>
            <li class="nav-item">
                <a class="flex-sm-fill text-secondary nav-link" href="<?= base_url(); ?>administrator/setting/seo"><i class="uil-google"></i> SEO</a>
            </li>
        </ul>
    </div>
    <hr class="mt-0 mb-0">
    <div class="card-body">
        <div class="alert alert-success" id="msgSettingPayment" style="display: none"></div>
        <div class="d-flex">
            <div class="custom-control mr-5 custom-switch">
                <?php if($setting['payment_feature'] == 1){ ?>
                    <input type="checkbox" checked class="custom-control-input" id="paymentFeatureSetting">
                <?php }else{ ?>
                    <input type="checkbox" class="custom-control-input" id="paymentFeatureSetting">
                <?php } ?>
                <label class="custom-control-label" for="paymentFeatureSetting">Aktifkan Fitur Pembayaran</label>
            </div>
            <div class="custom-control mr-5 custom-switch">
                <?php if($setting['uniq_code_feature'] == 1){ ?>
                    <input type="checkbox" checked class="custom-control-input" id="uniqCodeFeatureSetting">
                <?php }else{ ?>
                    <input type="checkbox" class="custom-control-input" id="uniqCodeFeatureSetting">
                <?php } ?>
                <label class="custom-control-label" for="uniqCodeFeatureSetting">Aktifkan Kode Unik</label>
            </div>
            <div class="custom-control custom-switch">
                <?php if($general['payment_cod_status'] == 1){ ?>
                    <input type="checkbox" checked class="custom-control-input" id="paymentCODFeatureSetting">
                <?php }else{ ?>
                    <input type="checkbox" class="custom-control-input" id="paymentCODFeatureSetting">
                <?php } ?>
                <label class="custom-control-label" for="paymentCODFeatureSetting">Aktifkan Pembayaran COD</label>
            </div>
        </div>
        <?php if($general['payment_cod_status'] == 1){ ?>
        <form action="<?= base_url(); ?>administrator/save_setting_payment_cod_feature" method="post" id="formColumnFeeCODWrapper">
        <?php }else{ ?>
        <form action="<?= base_url(); ?>administrator/save_setting_payment_cod_feature" method="post" id="formColumnFeeCODWrapper" style="display: none">
        <?php } ?>
            <div class="alert alert-info mt-3 mb-4">
                <div class="row">
                    <div class="col-lg-2">
                        <label for="fee_cod">Fee COD</label>
                        <div class="input-group mb-3">
                            <input
                                type="number"
                                class="form-control"
                                id="fee_cod"
                                name="fee_cod"
                                autocomplete="off"
                                placeholder="5"
                                value="<?= $general['fee_cod']; ?>"
                            />
                            <div class="input-group-append">
                                <span class="input-group-text" id="basic-addon2">%</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <label for="minimal_fee_cod">Minimal Ongkir</label>
                        <input
                            type="number"
                            class="form-control"
                            id="minimal_fee_cod"
                            name="minimal_fee_cod"
                            autocomplete="off"
                            placeholder="5000"
                            value="<?= $general['minimal_fee_cod']; ?>"
                        />
                    </div>
                    <div class="col-lg-3">
                        <label for="maximal_fee_cod">Maximal Ongkir</label>
                        <input
                            type="number"
                            class="form-control"
                            id="maximal_fee_cod"
                            name="maximal_fee_cod"
                            autocomplete="off"
                            placeholder="15000"
                            value="<?= $general['maximal_fee_cod']; ?>"
                        />
                    </div>
                </div>
                <button type="submit" class="btn btn-primary px-4">Simpan Pengaturan</button>
            </div>
        </form>
        <form action="<?= base_url(); ?>administrator/save_setting_payment" method="post">
            <?php foreach($rekening->result_array() as $r): ?>
            <div class="form-group mt-3" id="formSectionSettingPayment-<?= $r['rekeningId']; ?>">
                <div class="row">
                    <div class="col-md-4">
                        <select name="rekening[]" id="rekening" class="form-control">
                            <option value="<?= $r['rekening'] ?>"><?= $r['bankName'] ?></option>
                            <?php foreach($bank->result_array() as $d): ?>
                                <?php if($r['rekening'] != $d['id']){ ?>
                                <option value="<?= $d['id'] ?>"><?= $d['name']; ?></option>
                                <?php } ?>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <input type="text" name="number[]" id="number" autocomplete="off" class="form-control" value="<?= $r['number']; ?>">
                    </div>
                    <div class="col-md-3">
                        <input type="text" name="name[]" id="name" autocomplete="off" class="form-control" placeholder="Nama Pemilik Rekening" value="<?= $r['rekeningName']; ?>">
                    </div>
                    <input type="hidden" name="rekeningId[]" value="<?= $r['rekeningId']; ?>">
                    <div class="col-sm-1">
                        <i onclick="deleteRekening('<?= $r['rekeningId']; ?>')" style="cursor: pointer" class="fa mt-2 fa-trash h4 text-danger"></i>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
            <div class="form-add-bank-in-here-payment-setting">
                <div class="form-group mt-3" id="formSectionSettingPayment-1">
                    <div class="row">
                        <div class="col-md-4">
                            <select name="rekening[]" id="rekening" class="form-control">
                                <option value="0">Pilih Bank</option>
                                <?php foreach($bank->result_array() as $d): ?>
                                    <option value="<?= $d['id'] ?>"><?= $d['name']; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <input type="text" name="number[]" id="number" autocomplete="off" class="form-control">
                        </div>
                        <div class="col-md-3">
                            <input type="text" name="name[]" id="name" autocomplete="off" class="form-control" placeholder="Nama Pemilik Rekening">
                        </div>
                        <input type="hidden" name="rekeningId[]" value="0">
                        <div class="col-sm-1">
                            <i onclick="removeRekeningForm('1')" style="cursor: pointer" class="fa mt-2 fa-trash h4 text-danger"></i>
                        </div>
                    </div>
                </div>
            </div>
            <button id="btnAddFormBankPaymentSetting" type="button" class="btn btn-outline-primary">Tambah Pilihan</button><br>
            <button type="submit" class="btn mt-3 btn-primary px-4">Simpan Pengaturan</button>
        </form>
    </div>
</div>

<script src="<?= base_url(); ?>assets/admin/libs/jquery/jquery.min.js"></script>
<script>

    let globalIdFormBankPaymentSetting = 2;
    $("#btnAddFormBankPaymentSetting").on("click", function(){
        $(".form-add-bank-in-here-payment-setting").append(`
        <div class="form-group mt-3" id="formSectionSettingPayment-${globalIdFormBankPaymentSetting}">
            <div class="row">
                <div class="col-md-4">
                    <select name="rekening[]" id="rekening" class="form-control">
                        <option value="0">Pilih Bank</option>
                        <?php foreach($bank->result_array() as $d): ?>
                            <option value="<?= $d['id'] ?>"><?= $d['name']; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <input type="text" name="number[]" id="number" autocomplete="off" class="form-control">
                </div>
                <div class="col-md-3">
                    <input type="text" name="name[]" id="name" autocomplete="off" class="form-control" placeholder="Nama Pemilik Rekening">
                </div>
                <input type="hidden" name="rekeningId[]" value="0">
                <div class="col-sm-1">
                    <i onclick="removeRekeningForm('${globalIdFormBankPaymentSetting}')" style="cursor: pointer" class="fa mt-2 fa-trash h4 text-danger"></i>
                </div>
            </div>
        </div>
        `);
        globalIdFormBankPaymentSetting += 1;
    })

</script>