<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>Tokoorder License</title>

    <!-- Custom fonts for this template-->
    <link href="<?= base_url(); ?>assets/vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link
        href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i"
        rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="<?= base_url(); ?>assets/css/sb-admin-2.min.css" rel="stylesheet">

    <link rel="shortcut icon" href="<?= base_url(); ?>assets/images/logo/favicon.png" type="image/x-icon">

</head>

<body class="bg-light">

    <div class="container">

        <!-- Outer Row -->
        <div class="row justify-content-center">

            <div class="col-xl-5 col-lg-7 py-5 col-md-9">
                <a href="<?= base_url(); ?>"><img
                        src="<?= base_url(); ?>assets/images/logo/<?= $this->Settings_model->general()['logo-dark'] ?>"
                        alt="logo"
                        style="width: 180px; position: relative; left: 50%; transform: translate(-59%,0)"></a>
                <div class="card o-hidden border-0 shadow mt-4">
                    <div class="card-body p-0">
                        <!-- Nested Row within Card Body -->
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="p-5">
                                    <div class="text-center">
                                        <h1 class="h4 text-gray-900 mb-4">
                                            <?php echo $lic ? 'Reset and Deactivate license' : 'Activate License'; ?>
                                        </h1>
                                    </div>
                                    <?php if ($lic) : ?>
                                    <p>
                                        Kembali ke halaman admin <a href="<?php base_url(); ?>/administrator/">di
                                            sini</a>
                                    </p>
                                    <?php else : ?>
                                    <p>
                                        Dapatkan kode lisensi Anda <a
                                            href="https://app.tokoorder.com/member-area/license/" target="__blank">di
                                            sini</a>
                                    </p>
                                    <?php endif; ?>
                                    <?php echo $this->session->flashdata('failed'); ?>
                                    <form class="user" action="<?= base_url(); ?>license" method="post">
                                        <div class="form-group">
                                            <label for="email">Email</label>
                                            <input type="email" autocomplete="off" id="email" name="email" required
                                                class="form-control">
                                        </div>
                                        <div class="form-group">
                                            <label for="password">Password</label>
                                            <input type="text" autocomplete="off" id="password" name="password" required
                                                class="form-control">
                                        </div>
                                        <div class="form-group">
                                            <label for="code">Code</label>
                                            <input type="text" autocomplete="off" id="code" name="code" required
                                                class="form-control" value="<?php echo $lic ? $lic['license'] : ''; ?>">
                                        </div>
                                        <?php if ($lic) : ?>
                                        <input type="hidden" name="action" value="deactivate" />
                                        <?php else : ?>
                                        <input type="hidden" name="action" value="activate" />
                                        <?php endif; ?>
                                        <?php if ($lic) : ?>
                                        <div class="alert alert-warning" role="alert">
                                            Saat anda melakukan reset, semua data dalam website
                                            <?php echo $lic['string']; ?> akan hilang.
                                        </div>
                                        <?php endif; ?>
                                        <button type="submit" class="btn btn-block btn-primary"
                                            <?php echo $enable ? '' : 'disabled'; ?>>
                                            <?php echo $lic ? 'Reset and Deactivate Now' : 'Activate Now'; ?>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

        </div>
        
    </div>

    <script src="<?= base_url(); ?>assets/vendor/jquery/jquery.min.js"></script>
    <script src="<?= base_url(); ?>assets/vendor/bootstrap/js/bootstrap.bundle.min.js">
    </script>

</body>

</html>