<div class="wrapper">
    <h3 class="title">Cek Pesanan</h3>
    <div class="center">
        <form action="<?= base_url(); ?>tracking" method="get">
            <div class="form-group">
                <label for="invoice">Masukan Order ID</label>
                <input type="text" autocomplete="off" name="invoice" required value="<?= $invoice; ?>" id="invoice" class="form-control">
            </div>
            <div class="form-group">
                <label for="wa">Masukan No WhatsApp</label>
                <input type="number" autocomplete="off" name="wa" required value="<?= $wa; ?>" id="wa" class="form-control">
            </div>
            <button type="submit">CEK PESANAN</button>
        </form>
        <?php if($invoice != "" && $wa != ""){ ?>
            <hr>
            <?php if($order == ""){ ?>
                <div class="alert alert-danger">Pesanan dengan Order ID <strong><?=$invoice ?></strong> tidak ada</div>
            <?php }else{ ?>
                <?php if($order['status'] == 0){ ?>
                    <div class="alert alert-info mt-0" role="alert">
                        Pesanan kamu belum diproses
                    </div>
                <?php }else if($order['status'] == 1){ ?>
                    <div class="alert alert-info mt-0" role="alert">
                        Pesanan kamu sedang diproses
                    </div>
                <?php }else if($order['status'] == 2){ ?>
                    <div class="alert alert-info mb-2 mt-0" role="alert">
                        Pesanan kamu sedang dalam perjalanan
                    </div>
                    <button data-toggle="modal" data-target=".bd-example-modal-lg" class="btn btn-sm mb-2 btn-secondary">Lacak Pesanan</button>
                <?php }else if($order['status'] == 3){ ?>
                    <div class="alert alert-info mb-2 mt-0" role="alert">
                        Pesanan kamu sudah sampai
                    </div>
                    <button data-toggle="modal" data-target=".bd-example-modal-lg" class="btn btn-sm mb-2 btn-secondary">Lacak Pesanan</button>
                <?php } ?>
                <table class="table mt-1 table-sm table-borderless">
                    <tr>
                        <th>Order ID</th>
                        <td>: <?= $invoice ?></td>
                    </tr>
                    <tr>
                        <th>Nama</th>
                        <td>: <?= $order['name'] ?></td>
                    </tr>
                    <tr>
                        <th>WhatsApp</th>
                        <td>: <?= $order['telp'] ?></td>
                    </tr>
                    <tr>
                        <th>Total</th>
                        <td>: Rp. <?= $order['total_all'] ?></td>
                    </tr>
                    <tr>
                        <th>Alamat</th>
                        <td>: <?= $order['address'] ?></td>
                    </tr>
                </table>
                <strong class="mb-0">Daftar Pesanan</strong>
                <ul>
                    <?php foreach($this->Products_model->getTransactionByInvoice($invoice)->result_array() as $d): ?>
                        <li><?= $d['product_name']; ?></li>
                    <?php endforeach; ?>
                </ul>
            <?php } ?>
        <?php } ?>
    </div>
</div>

<div class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-body">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            <div class="row">
                <div class="col-lg-5">
                  <div class="container py-3">
                      <h5>Lacak</h4>
                      <table class="table table-borderless table-sm">
                          <tr>
                              <td>Kurir:</td>
                              <td><?= strtoupper($order['courier']) ?></td>
                          </tr>
                          <tr>
                              <td width="90">Layanan:</td>
                              <td><?= $order['courier_service']; ?></td>
                          </tr>
                      </table>
                      <hr>
                      <p class="text-secondary mb-0">Nomor Resi</p>
                      <p class="font-weight-bold"><?= $order['resi']; ?></p>
                      <hr>
                      <p class="text-secondary mb-0">Pengirim</p>
                      <p class="font-weight-bold"><?= $waybill['result']['summary']['shipper_name'] ?></p>
                      <hr>
                      <p class="text-secondary mb-0">Penerima</p>
                      <p class="font-weight-bold mb-0"><?= $waybill['result']['summary']['receiver_name'] ?></p>
                      <p class="address-tracking text-secondary"><small><?= $order['address']; ?></small></p>
                    </div>
                    </div>
                  <div class="col-lg-7 rounded bg-light">
                      <div class="modal-body">
                        <?php if($waybill['result'] == null){ ?>
                            <div class="alert alert-warning">Resi pengiriman tidak ditemukan, silakan coba beberapa saat lagi.</div>
                        <?php }else{ ?>
                            <div class="line-track">
                                <p class="lead">Status: <?= $waybill['result']['summary']['status'] ?></p>
                                <hr>
                                <?php foreach($waybill['result']['manifest'] as $d): ?>
                                <div class="line-track-item">
                                    <div class="vertical-line">
                                        <div class="dot"></div>
                                        <div class="line-main"></div>
                                    </div>
                                    <div class="content-track">
                                        <p class="time mb-0"><?= $d['manifest_date']; ?>, <?= $d['manifest_time']; ?></p>
                                        <p class="desc mb-0"><?= $d['manifest_description']; ?></p>
                                        <p class="city"><?= $d['city_name']; ?></p>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        <?php } ?>
                      </div>
                  </div>
              </div>
          </div>
    </div>
  </div>
</div>