<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <title><?= $title ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />

    <!-- Light layout Bootstrap Css -->
    <link href="<?= base_url(); ?>assets/admin/css/bootstrap-dark.min.css" id="bootstrap-dark-style" disabled="disabled" rel="stylesheet" type="text/css" />
    <link href="<?= base_url(); ?>assets/admin/css/bootstrap.min.css" id="bootstrap-style" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="<?= base_url(); ?>assets/admin/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="<?= base_url(); ?>assets/admin/css/app-dark.min.css" id="app-dark-style" disabled="disabled" rel="stylesheet" type="text/css" />
    <link href="<?= base_url(); ?>assets/admin/css/app-rtl.min.css" id="app-rtl-style" disabled="disabled" rel="stylesheet" type="text/css" />
    <link href="<?= base_url(); ?>assets/admin/css/app.min.css" id="app-style" rel="stylesheet" type="text/css" />

    <link href="<?= base_url(); ?>assets/color-picker/dist/css/bootstrap-colorpicker.css" rel="stylesheet">

    <link rel="stylesheet" href="<?= base_url(); ?>assets/select2-4.0.6-rc.1/dist/css/select2.min.css">

    <link rel="shortcut icon" href="<?= base_url(); ?>assets/images/logo/<?= $this->Settings_model->general()['favicon']; ?>" type="image/x-icon" />

    <style>
        .clearfix {
            clear: both;
        }

        /* Chrome, Safari, Edge, Opera */
        input::-webkit-outer-spin-button,
        input::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }

        /* Firefox */
        input[type=number] {
            -moz-appearance: textfield;
        }

        div.div-hijrah-to-textarea {
            font-family: sans-serif;
            resize: vertical;
            overflow: auto;
            min-height: 200px;
            width: 100%;
        }
    </style>

    <script src="https://cdn.ckeditor.com/ckeditor5/18.0.0/classic/ckeditor.js"></script>

    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
</head>

<body>
    <div id="layout-wrapper">
        <header id="page-topbar">
            <div class="navbar-header">
                <div class="d-flex">
                    <!-- LOGO -->
                    <div class="navbar-brand-box">
                        <a href="<?= base_url(); ?>administrator" class="logo logo-dark">
                            <span class="logo-sm">
                                <img src="<?= base_url(); ?>assets/images/logo/<?= $this->Settings_model->general()['favicon'] ?>" alt="" height="30" />
                            </span>
                            <span class="logo-lg">
                                <img src="<?= base_url(); ?>assets/images/logo/<?= $this->Settings_model->general()['logo-dark'] ?>" alt="" height="30" />
                            </span>
                        </a>

                        <a href="<?= base_url(); ?>administrator" class="logo logo-light">
                            <span class="logo-sm">
                                <img src="<?= base_url(); ?>assets/images/logo/<?= $this->Settings_model->general()['favicon'] ?>" alt="" height="30" />
                            </span>
                            <span class="logo-lg">
                                <img src="<?= base_url(); ?>assets/images/logo/<?= $this->Settings_model->general()['logo'] ?>" alt="" height="30" />
                            </span>
                        </a>
                    </div>

                    <button type="button" class="btn btn-sm px-3 font-size-16 header-item waves-effect vertical-menu-btn">
                        <i class="fa fa-fw fa-bars"></i>
                    </button>
                </div>

                <div class="d-flex">
                    <div class="dropdown d-inline-block">
                        <button type="button" class="btn header-item waves-effect" id="page-header-user-dropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <img class="rounded-circle header-profile-user" src="<?= base_url(); ?>assets/images/icon/profile-admin.png" alt="Header Avatar" />
                            <span class="d-none d-xl-inline-block ml-1 font-weight-medium font-size-15">Admin</span>
                            <i class="uil-angle-down d-none d-xl-inline-block font-size-15"></i>
                        </button>
                        <div class="dropdown-menu dropdown-menu-right">
                            <!-- item-->
                            <a class="dropdown-item d-block" href="<?= base_url(); ?>administrator/edit"><i class="uil uil-cog font-size-18 align-middle mr-1 text-muted"></i>
                                <span class="align-middle">Edit Profil</span></a>
                            <a class="dropdown-item d-block" href="<?= base_url(); ?>license"><i class="uil uil-cog font-size-18 align-middle mr-1 text-muted"></i>
                                <span class="align-middle">Lisensi</span></a>
                            <a class="dropdown-item" href="<?= base_url(); ?>administrator/logout"><i class="uil uil-sign-out-alt font-size-18 align-middle mr-1 text-muted"></i>
                                <span class="align-middle">Keluar</span></a>
                        </div>
                    </div>
                </div>
            </div>
        </header>

        <div class="vertical-menu">
            <!-- LOGO -->
            <div class="navbar-brand-box">
                <a href="/" class="logo logo-dark">
                    <span class="logo-sm">
                        <img src="<?= base_url(); ?>assets/images/logo/<?= $this->Settings_model->general()['favicon'] ?>" alt="" height="30" />
                    </span>
                    <span class="logo-lg">
                        <img src="<?= base_url(); ?>assets/images/logo/<?= $this->Settings_model->general()['logo-dark'] ?>" alt="" height="30" />
                    </span>
                </a>

                <a href="/" class="logo logo-light">
                    <span class="logo-sm">
                        <img src="<?= base_url(); ?>assets/images/logo/<?= $this->Settings_model->general()['logo'] ?>" alt="" height="30" />
                    </span>
                    <span class="logo-lg">
                        <img src="<?= base_url(); ?>assets/images/logo/<?= $this->Settings_model->general()['logo'] ?>" alt="" height="30" />
                    </span>
                </a>
            </div>

            <button type="button" class="btn btn-sm px-3 font-size-16 header-item waves-effect vertical-menu-btn">
                <i class="fa fa-fw fa-bars"></i>
            </button>

            <div data-simplebar class="sidebar-menu-scroll">
                <!--- Sidemenu -->
                <div id="sidebar-menu">
                    <!-- Left Menu Start -->
                    <ul class="metismenu list-unstyled" id="side-menu">
                        <li>
                            <a href="<?= base_url(); ?>administrator" class="waves-effect">
                                <i class="uil-dashboard"></i>
                                <span>Dashboard</span>
                            </a>
                        </li>

                        <li class="menu-title">Order</li>

                        <?php $data = $this->db->get_where('invoice', ['status' => 0]); ?>
                        <?php if ($data->num_rows() > 0) { ?>
                            <li>
                                <a href="<?= base_url(); ?>administrator/orders" class="waves-effect">
                                    <i class="uil-shopping-basket"></i>
                                    <span class="badge badge-pill badge-primary float-right"><?= $data->num_rows(); ?></span>
                                    <span>Pesanan</span>
                                </a>
                            </li>
                        <?php } else { ?>
                            <li>
                                <a href="<?= base_url(); ?>administrator/orders" class="waves-effect">
                                    <i class="uil-shopping-basket"></i>
                                    <span>Pesanan</span>
                                </a>
                            </li>
                        <?php } ?>

                        <li class="menu-title">Produk</li>

                        <li>
                            <a href="<?= base_url(); ?>administrator/products" class="waves-effect">
                                <i class="uil-store"></i>
                                <span>Produk</span>
                            </a>
                        </li>

                        <?php $ratingsRow = $this->db->get_where('rating', ['active' => 0])->num_rows(); ?>
                        <li>
                            <a href="<?= base_url(); ?>administrator/ratings" class="waves-effect">
                                <i class="uil-star"></i>
                                <?php if ($ratingsRow > 0) { ?>
                                    <span class="badge badge-pill badge-primary float-right"><?= $ratingsRow; ?></span>
                                <?php } ?>
                                <span>Rating</span>
                            </a>
                        </li>

                        <li>
                            <a href="<?= base_url(); ?>administrator/categories" class="waves-effect">
                                <i class="uil-layer-group"></i>
                                <span>Kategori</span>
                            </a>
                        </li>

                        <li>
                            <a href="<?= base_url(); ?>administrator/coupon" class="waves-effect">
                                <i class="uil-tag-alt"></i>
                                <span>Kupon</span>
                            </a>
                        </li>

                        <li class="menu-title">Halaman</li>

                        <li>
                            <a href="<?= base_url(); ?>administrator/pages" class="waves-effect">
                                <i class="uil-clipboard-blank"></i>
                                <span>Page</span>
                            </a>
                        </li>

                        <li>
                            <a href="<?= base_url(); ?>administrator/report" class="waves-effect">
                                <i class="uil-clock-two"></i>
                                <span>Laporan</span>
                            </a>
                        </li>

                        <li class="menu-title">Setting</li>

                        <li>
                            <a href="<?= base_url(); ?>administrator/banner-popup" class="waves-effect">
                                <i class="uil-comment-info"></i>
                                <span>Banner Pop up</span>

                            </a>
                        </li>

                        <li>
                            <a href="<?= base_url(); ?>administrator/design/header" class="waves-effect">
                                <i class="uil-flask"></i>
                                <span>Tampilan</span>

                            </a>
                        </li>

                        <li>
                            <a href="<?= base_url(); ?>administrator/setting/account" class="waves-effect">
                                <i class="uil-cog"></i>
                                <span>Pengaturan</span>
                            </a>
                        </li>
                    </ul>
                </div>
                <!-- Sidebar -->
            </div>
        </div>

        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">
                    <?php echo $this->session->flashdata('license_activated'); ?>
                    <?php echo $this->session->flashdata('license_expired'); ?>